package net.guerlab.smart.wx.auth.interceptor;

import net.guerlab.smart.platform.auth.interceptor.AbstractHandlerInterceptor;
import net.guerlab.smart.platform.commons.exception.AccessTokenInvalidException;
import net.guerlab.smart.wx.auth.WxUserContextHandler;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.method.HandlerMethod;

import javax.servlet.http.HttpServletRequest;

/**
 * token后置处理
 *
 * @author guer
 */
public class WxUserTokenHandlerAfterInterceptor extends AbstractHandlerInterceptor {

    @Override
    protected void preHandle0(HttpServletRequest request, HandlerMethod handlerMethod) {
        if (StringUtils.isAnyBlank(WxUserContextHandler.getAppId(), WxUserContextHandler.getOpenId())) {
            throw new AccessTokenInvalidException();
        }
    }
}
