package net.guerlab.smart.wx.auth;

import net.guerlab.smart.platform.auth.AbstractContextHandler;
import net.guerlab.smart.wx.core.WxUserAuthConstants;

/**
 * 上下文处理
 *
 * @author guer
 */
@SuppressWarnings("WeakerAccess")
public final class WxUserContextHandler extends AbstractContextHandler {

    private WxUserContextHandler() {

    }

    /**
     * 获取openId
     *
     * @return openId
     */
    public static String getOpenId() {
        return get(WxUserAuthConstants.OPEN_ID);
    }

    /**
     * 设置openId
     *
     * @param openId
     *         openId
     */
    public static void setOpenId(String openId) {
        set(WxUserAuthConstants.OPEN_ID, openId);
    }

    /**
     * 获取unionId
     *
     * @return unionId
     */
    public static String getUnionId() {
        return get(WxUserAuthConstants.UNION_ID);
    }

    /**
     * 设置unionId
     *
     * @param unionId
     *         unionId
     */
    public static void setUnionId(String unionId) {
        set(WxUserAuthConstants.UNION_ID, unionId);
    }

    /**
     * 获取appId
     *
     * @return appId
     */
    public static String getAppId() {
        return get(WxUserAuthConstants.APP_ID);
    }

    /**
     * 设置appId
     *
     * @param appId
     *         appId
     */
    public static void setAppId(String appId) {
        set(WxUserAuthConstants.APP_ID, appId);
    }

    /**
     * 获取头像地址
     *
     * @return 头像地址
     */
    public static String getAvatarUrl() {
        return get(WxUserAuthConstants.AVATAR_URL);
    }

    /**
     * 设置头像地址
     *
     * @param avatarUrl
     *         头像地址
     */
    public static void setAvatarUrl(String avatarUrl) {
        set(WxUserAuthConstants.AVATAR_URL, avatarUrl);
    }

    /**
     * 获取昵称
     *
     * @return 昵称
     */
    public static String getNickName() {
        return get(WxUserAuthConstants.NICK_NAME);
    }

    /**
     * 设置昵称
     *
     * @param nickName
     *         昵称
     */
    public static void setNickName(String nickName) {
        set(WxUserAuthConstants.NICK_NAME, nickName);
    }

    /**
     * 获取账号是否激活
     *
     * @return 账号是否激活
     */
    public static boolean isActivated() {
        return get(WxUserAuthConstants.ACTIVATED);
    }

    /**
     * 设置账号是否激活
     *
     * @param activated
     *         账号是否激活
     */
    public static void setActivated(boolean activated) {
        set(WxUserAuthConstants.ACTIVATED, activated);
    }

}
