package net.guerlab.smart.wx.auth.interceptor;

import net.guerlab.smart.platform.auth.interceptor.AbstractTokenHandlerInterceptor;
import net.guerlab.smart.platform.commons.ip.IpUtils;
import net.guerlab.smart.wx.auth.WxUserContextHandler;
import net.guerlab.smart.wx.auth.factory.WxUserJwtTokenFactory;
import net.guerlab.smart.wx.auth.properties.WxUserAuthProperties;
import net.guerlab.smart.wx.core.entity.IWxUserTokenInfo;
import org.springframework.beans.factory.annotation.Autowired;

import javax.servlet.http.HttpServletRequest;

/**
 * jwt token处理
 *
 * @author guer
 */
public class WxUserJwtTokenHandlerInterceptor extends AbstractTokenHandlerInterceptor<WxUserAuthProperties> {

    private WxUserJwtTokenFactory tokenFactory;

    @Override
    protected boolean accept(String token, HttpServletRequest request) {
        String ip = IpUtils.getIp(request);

        return tokenFactory.enabled() && tokenFactory.acceptAccessToken(token) && tokenFactory.acceptIp(ip);
    }

    @Override
    protected void setTokenInfo(String token) {
        IWxUserTokenInfo tokenInfo = tokenFactory.parseByAccessToken(token);

        WxUserContextHandler.setOpenId(tokenInfo.getOpenId());
        WxUserContextHandler.setUnionId(tokenInfo.getUnionId());
        WxUserContextHandler.setAppId(tokenInfo.getAppId());
        WxUserContextHandler.setNickName(tokenInfo.getNickName());
        WxUserContextHandler.setAvatarUrl(tokenInfo.getAvatarUrl());
    }

    @Autowired
    public void setTokenFactory(WxUserJwtTokenFactory tokenFactory) {
        this.tokenFactory = tokenFactory;
    }
}
