package net.guerlab.smart.wx.auth.autoconfig;

import net.guerlab.smart.platform.basic.auth.autoconfig.AbstractAuthInterceptorAutoconfigure;
import net.guerlab.smart.wx.auth.interceptor.WxUserTokenHandlerAfterInterceptor;
import net.guerlab.smart.wx.auth.properties.WxUserAuthProperties;
import net.guerlab.smart.wx.auth.properties.WxUserJwtProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;

/**
 * 鉴权拦截器配置
 *
 * @author guer
 */
@Order
@Configuration
@EnableConfigurationProperties({ WxUserAuthProperties.class, WxUserJwtProperties.class })
public class WxUserAuthInterceptorAutoconfigure extends AbstractAuthInterceptorAutoconfigure<WxUserAuthProperties> {

    private WxUserTokenHandlerAfterInterceptor tokenHandlerAfterInterceptor;

    @Override
    public void addInterceptorsInternal(InterceptorRegistry registry) {
        setPathPatterns(registry.addInterceptor(tokenHandlerAfterInterceptor));
    }

    @Autowired
    public void setTokenHandlerAfterInterceptor(WxUserTokenHandlerAfterInterceptor tokenHandlerAfterInterceptor) {
        this.tokenHandlerAfterInterceptor = tokenHandlerAfterInterceptor;
    }
}
