/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.wx.auth.utils;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtBuilder;
import net.guerlab.smart.platform.basic.auth.utils.AbstractJwtHelper;
import net.guerlab.smart.wx.auth.properties.WxUserJwtProperties;
import net.guerlab.smart.wx.core.entity.IJwtInfo;
import net.guerlab.smart.wx.core.entity.JwtInfo;
import org.apache.commons.lang3.StringUtils;

public class WxUserJwtHelper
extends AbstractJwtHelper<IJwtInfo, WxUserJwtProperties> {
    public static final String PREFIX = "WX_USER_JWT";

    protected void generateToken0(JwtBuilder builder, IJwtInfo user) {
        Boolean activated = user.getActivated();
        builder.setSubject(user.getNickName());
        builder.claim("openId", (Object)StringUtils.trimToEmpty((String)user.getOpenId()));
        builder.claim("unionId", (Object)StringUtils.trimToEmpty((String)user.getUnionId()));
        builder.claim("appId", (Object)StringUtils.trimToEmpty((String)user.getAppId()));
        builder.claim("avatarUrl", (Object)StringUtils.trimToEmpty((String)user.getAvatarUrl()));
        builder.claim("activated", (Object)(activated == null ? false : activated));
    }

    protected IJwtInfo parse0(Claims body) {
        String openId = (String)body.get("openId", String.class);
        String unionId = (String)body.get("unionId", String.class);
        String appId = (String)body.get("appId", String.class);
        String nickName = body.getSubject();
        String avatarUrl = (String)body.get("avatarUrl", String.class);
        Boolean activated = (Boolean)body.get("activated", Boolean.class);
        JwtInfo jwtInfo = new JwtInfo();
        jwtInfo.setOpenId(openId);
        jwtInfo.setUnionId(unionId);
        jwtInfo.setAppId(appId);
        jwtInfo.setNickName(nickName);
        jwtInfo.setAvatarUrl(avatarUrl);
        jwtInfo.setActivated(activated);
        return jwtInfo;
    }

    protected String getPrefix() {
        return PREFIX;
    }
}

