/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.wx.auth.interceptor;

import net.guerlab.smart.platform.basic.auth.interceptor.AbstractTokenHandlerInterceptor;
import net.guerlab.smart.wx.auth.WxUserContextHandler;
import net.guerlab.smart.wx.auth.properties.WxUserAuthProperties;
import net.guerlab.smart.wx.auth.utils.WxUserJwtHelper;
import net.guerlab.smart.wx.core.entity.IJwtInfo;
import org.springframework.beans.factory.annotation.Autowired;

public class WxUserJwtTokenHandlerInterceptor
extends AbstractTokenHandlerInterceptor<WxUserAuthProperties> {
    private static final String PREFIX = "WX_USER_JWT AT ";
    private WxUserJwtHelper jwtHelper;

    protected boolean accept(String token) {
        return token.startsWith(PREFIX);
    }

    protected void setTokenInfo(String token) {
        String jwtToken = token.substring(PREFIX.length());
        IJwtInfo jwtInfo = (IJwtInfo)this.jwtHelper.parseByAccessTokenKey(jwtToken);
        WxUserContextHandler.setOpenId(jwtInfo.getOpenId());
        WxUserContextHandler.setUnionId(jwtInfo.getUnionId());
        WxUserContextHandler.setAppId(jwtInfo.getAppId());
        WxUserContextHandler.setNickName(jwtInfo.getNickName());
        WxUserContextHandler.setAvatarUrl(jwtInfo.getAvatarUrl());
    }

    @Autowired
    public void setJwtHelper(WxUserJwtHelper jwtHelper) {
        this.jwtHelper = jwtHelper;
    }
}

