package net.guerlab.smart.wx.auth.interceptor;

import net.guerlab.smart.platform.basic.auth.enums.TokenType;
import net.guerlab.smart.platform.basic.auth.interceptor.AbstractTokenHandlerInterceptor;
import net.guerlab.smart.platform.basic.auth.utils.AbstractJwtHelper;
import net.guerlab.smart.wx.auth.WxUserContextHandler;
import net.guerlab.smart.wx.auth.utils.WxUserJwtHelper;
import net.guerlab.smart.wx.core.entity.IJwtInfo;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * jwt token处理
 *
 * @author guer
 */
public class WxUserJwtTokenHandlerInterceptor extends AbstractTokenHandlerInterceptor {

    private static final String PREFIX =
            WxUserJwtHelper.PREFIX + AbstractJwtHelper.CONNECTORS + TokenType.SIMPLE_NAME_ACCESS_TOKEN
                    + AbstractJwtHelper.CONNECTORS;

    private WxUserJwtHelper jwtHelper;

    @Override
    protected boolean accept(String token) {
        return token.startsWith(PREFIX);
    }

    @Override
    protected void setTokenInfo(String token) {
        String jwtToken = token.substring(PREFIX.length());
        IJwtInfo jwtInfo = jwtHelper.parseByAccessTokenKey(jwtToken);

        WxUserContextHandler.setOpenId(jwtInfo.getOpenId());
        WxUserContextHandler.setUnionId(jwtInfo.getUnionId());
        WxUserContextHandler.setAppId(jwtInfo.getAppId());
        WxUserContextHandler.setNickName(jwtInfo.getNickName());
        WxUserContextHandler.setAvatarUrl(jwtInfo.getAvatarUrl());
    }

    @Autowired
    public void setJwtHelper(WxUserJwtHelper jwtHelper) {
        this.jwtHelper = jwtHelper;
    }
}
