/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.wx.api.autoconfig;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.guerlab.commons.collection.CollectionUtil;
import net.guerlab.smart.platform.commons.util.BeanConvertUtils;
import net.guerlab.smart.wx.api.WxUserApi;
import net.guerlab.smart.wx.core.domain.WxUserDTO;
import net.guerlab.smart.wx.core.exception.WxUserInvalidException;
import net.guerlab.smart.wx.core.searchparams.WxUserSearchParams;
import net.guerlab.smart.wx.service.entity.WxUser;
import net.guerlab.smart.wx.service.service.WxUserService;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import net.guerlab.web.result.ListObject;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.lang.NonNull;

@Configuration
@Conditional(value={WrapperCondition.class})
public class WxUserApiLocalServiceAutoConfigure {
    @Bean
    @ConditionalOnBean(value={WxUserService.class})
    public WxUserApi wxUserApiLocalServiceWrapper(WxUserService service) {
        return new WxUserApiLocalServiceWrapper(service);
    }

    private static class WxUserApiLocalServiceWrapper
    implements WxUserApi {
        private final WxUserService service;

        @Override
        public WxUserDTO findOne(String appId, String openId) {
            WxUser wxUser = this.service.findUser(appId, openId);
            if (wxUser == null) {
                throw new WxUserInvalidException();
            }
            return wxUser.convert();
        }

        @Override
        public ListObject<WxUserDTO> findList(WxUserSearchParams searchParams) {
            return BeanConvertUtils.toListObject((ListObject)this.service.selectPage((AbstractSearchParams)searchParams));
        }

        @Override
        public List<WxUserDTO> findAll(WxUserSearchParams searchParams) {
            return BeanConvertUtils.toList((Collection)this.service.selectAll((AbstractSearchParams)searchParams));
        }

        @Override
        public Map<String, WxUserDTO> findMap(Collection<String> openIds) {
            if (openIds == null || openIds.isEmpty()) {
                return Collections.emptyMap();
            }
            WxUserSearchParams searchParams = new WxUserSearchParams();
            searchParams.setOpenIds(openIds);
            Collection wxUsers = this.service.selectAll((AbstractSearchParams)searchParams);
            return CollectionUtil.toMap((Collection)wxUsers, WxUser::getOpenId, WxUser::convert);
        }

        @Override
        public int findCount(WxUserSearchParams searchParams) {
            return this.service.selectCount((AbstractSearchParams)searchParams);
        }

        public WxUserApiLocalServiceWrapper(WxUserService service) {
            this.service = service;
        }
    }

    static class WrapperCondition
    implements Condition {
        WrapperCondition() {
        }

        public boolean matches(@NonNull ConditionContext context, @NonNull AnnotatedTypeMetadata metadata) {
            try {
                return WrapperCondition.class.getClassLoader().loadClass("net.guerlab.smart.wx.service.service.WxUserService") != null;
            }
            catch (Exception e) {
                return false;
            }
        }
    }
}

