/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.wx.api.autoconfig;

import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.smart.wx.api.WxMaApi;
import net.guerlab.smart.wx.api.autoconfig.WxMaApiLocalServiceAutoConfigure;
import net.guerlab.smart.wx.api.feign.FeignWxMaApi;
import net.guerlab.smart.wx.core.domain.LoginResponse;
import net.guerlab.smart.wx.core.domain.MaEncryptedData;
import net.guerlab.web.result.Result;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={WxMaApiLocalServiceAutoConfigure.class})
public class WxMaApiFeignAutoConfigure {
    @Bean
    @ConditionalOnMissingBean(value={WxMaApi.class})
    public WxMaApi wxMaApiFeignWrapper(FeignWxMaApi api) {
        return new WxMaApiFeignWrapper(api);
    }

    private static class WxMaApiFeignWrapper
    implements WxMaApi {
        private final FeignWxMaApi api;

        @Override
        public LoginResponse login(String appId, String code) {
            Result<LoginResponse> result = this.api.login(appId, code);
            if (result.isStatus()) {
                return (LoginResponse)result.getData();
            }
            throw new ApplicationException(result.getMessage(), result.getErrorCode());
        }

        @Override
        public LoginResponse register(String appId, String openId, MaEncryptedData encryptedData) {
            Result<LoginResponse> result = this.api.register(appId, openId, encryptedData);
            if (result.isStatus()) {
                return (LoginResponse)result.getData();
            }
            throw new ApplicationException(result.getMessage(), result.getErrorCode());
        }

        @Override
        public String getAccessToken(String appId) {
            Result<String> result = this.api.getAccessToken(appId);
            if (result.isStatus()) {
                return (String)result.getData();
            }
            throw new ApplicationException(result.getMessage(), result.getErrorCode());
        }

        @Override
        public String getPhoneNumber(String appId, String openId, MaEncryptedData encryptedData) {
            Result<String> result = this.api.getPhoneNumber(appId, openId, encryptedData);
            if (result.isStatus()) {
                return (String)result.getData();
            }
            throw new ApplicationException(result.getMessage(), result.getErrorCode());
        }

        public WxMaApiFeignWrapper(FeignWxMaApi api) {
            this.api = api;
        }
    }
}

