/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.smart.wx.api.feign;

import net.guerlab.smart.wx.api.feign.factory.FeignWxUserLoginLogApiFallbackFactory;
import net.guerlab.smart.wx.core.domain.WxUserLoginLogDTO;
import net.guerlab.web.result.ListObject;
import net.guerlab.web.result.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;
import java.util.Map;

/**
 * 微信用户登录记录服务接口
 *
 * @author guer
 */
@FeignClient(value = "wx-internal", path = "/inside/wxUserLoginLog", fallbackFactory = FeignWxUserLoginLogApiFallbackFactory.class)
public interface FeignWxUserLoginLogApi {

    /**
     * 根据搜索参数查询微信用户登录记录列表
     *
     * @param searchParams
     *         搜索参数
     * @return 微信用户登录记录列表
     */
    @PostMapping
    Result<ListObject<WxUserLoginLogDTO>> findList(@RequestBody Map<String, Object> searchParams);

    /**
     * 根据搜索参数查询微信用户登录记录列表
     *
     * @param searchParams
     *         搜索参数
     * @return 微信用户登录记录列表
     */
    @PostMapping("/all")
    Result<List<WxUserLoginLogDTO>> findAll(@RequestBody Map<String, Object> searchParams);
}
