/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.smart.wx.api.feign;

import net.guerlab.smart.wx.api.feign.factory.FeignWxMaContentSecurityApiFallbackFactory;
import net.guerlab.web.result.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 小程序-内容安全服务接口
 *
 * @author guer
 */
@FeignClient(value = "wx-internal", path = "/inside/wxMaContentSecurity", fallbackFactory = FeignWxMaContentSecurityApiFallbackFactory.class)
public interface FeignWxMaContentSecurityApi {

    /**
     * 校验一张图片是否含有违法违规内容
     *
     * @param appId
     *         应用ID
     * @param fileUrl
     *         图片网络地址
     * @return 响应
     */
    @PostMapping("/{appId}/checkImage")
    Result<Void> checkImage(@PathVariable("appId") String appId, @RequestBody String fileUrl);

    /**
     * 检查一段文本是否含有违法违规内容
     *
     * @param appId
     *         应用ID
     * @param msg
     *         文本内容
     * @return 响应
     */
    @PostMapping("/{appId}/checkMessage")
    Result<Void> checkMessage(@PathVariable("appId") String appId, @RequestBody String msg);
}
