/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.smart.wx.api.feign;

import net.guerlab.smart.wx.api.feign.factory.FeignWxCpApiFallbackFactory;
import net.guerlab.smart.wx.core.domain.WxCpOauth2UserInfoDTO;
import net.guerlab.web.result.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;

/**
 * 企业微信服务接口
 *
 * @author guer
 */
@FeignClient(value = "wx-internal", path = "/inside/wx/cp", fallbackFactory = FeignWxCpApiFallbackFactory.class)
public interface FeignWxCpApi {

    /**
     * 获取accessToken
     *
     * @param appId
     *         appId
     * @return accessToken
     */
    @GetMapping("/{appId}/accessToken")
    Result<String> getAccessToken(@PathVariable("appId") String appId);

    /**
     * 通过code获取用户信息
     *
     * @param appId
     *         appId
     * @param code
     *         code
     * @return 企业微信用户Oauth信息
     */
    @GetMapping("/{appId}/{code}/getCodeInfo")
    Result<WxCpOauth2UserInfoDTO> getCodeInfo(@PathVariable("appId") String appId, @PathVariable("code") String code);
}
