/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.smart.wx.api.autoconfig;

import lombok.AllArgsConstructor;
import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.smart.wx.api.WxMaSubscribeMsgApi;
import net.guerlab.smart.wx.api.feign.FeignWxMaSubscribeMsgApi;
import net.guerlab.smart.wx.core.message.SendMsgResponse;
import net.guerlab.smart.wx.core.message.WxMaSubscribeMessageSendRequest;
import net.guerlab.web.result.Result;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.Map;

/**
 * @author guer
 */
@Configuration
@AutoConfigureAfter(WxMaSubscribeMsgApiLocalServiceAutoConfigure.class)
public class WxMaSubscribeMsgApiFeignAutoConfigure {

    @SuppressWarnings("SpringJavaInjectionPointsAutowiringInspection")
    @Bean
    @ConditionalOnMissingBean(WxMaSubscribeMsgApi.class)
    public WxMaSubscribeMsgApi wxMaSubscribeMsgApiFeignWrapper(FeignWxMaSubscribeMsgApi api) {
        return new WxMaSubscribeMsgApiFeignWrapper(api);
    }

    @AllArgsConstructor
    private static class WxMaSubscribeMsgApiFeignWrapper implements WxMaSubscribeMsgApi {

        private final FeignWxMaSubscribeMsgApi api;

        @Override
        public Map<String, SendMsgResponse> sendMsg(String appId, WxMaSubscribeMessageSendRequest sendData) {
            Result<Map<String, SendMsgResponse>> result = api.sendMsg(appId, sendData);

            if (result.isStatus()) {
                return result.getData();
            }

            throw new ApplicationException(result.getMessage(), result.getErrorCode());
        }
    }

}
