/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.smart.wx.api;

import net.guerlab.smart.wx.core.domain.LoginResponse;
import net.guerlab.smart.wx.core.domain.MaEncryptedData;

/**
 * 微信小程序服务接口
 *
 * @author guer
 */
public interface WxMaApi {

    /**
     * 换取token
     *
     * @param appId
     *         appId
     * @param code
     *         code
     * @return 微信用户
     */
    LoginResponse login(String appId, String code);

    /**
     * 注册用户
     *
     * @param appId
     *         appId
     * @param openId
     *         openId
     * @param encryptedData
     *         小程序加密信息请求
     * @return 微信用户
     */
    LoginResponse register(String appId, String openId, MaEncryptedData encryptedData);

    /**
     * 获取accessToken
     *
     * @param appId
     *         appId
     * @return accessToken
     */
    String getAccessToken(String appId);

    /**
     * 获取手机号
     *
     * @param appId
     *         appId
     * @param openId
     *         openId
     * @param encryptedData
     *         小程序加密信息请求
     * @return 手机号
     */
    String getPhoneNumber(String appId, String openId, MaEncryptedData encryptedData);
}
