/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.smart.wx.api;

import net.guerlab.smart.wx.core.domain.WxCpOauth2UserInfoDTO;
import net.guerlab.smart.wx.core.utils.WxCpUtils;

/**
 * 微信小程序服务接口
 *
 * @author guer
 */
public interface WxCpApi {

    /**
     * 获取accessToken
     *
     * @param appId
     *         appId
     * @return accessToken
     */
    String getAccessToken(String appId);

    /**
     * 获取accessToken
     *
     * @param corpId
     *         corpId
     * @param agentId
     *         agentId
     * @return accessToken
     */
    default String getAccessToken(String corpId, Integer agentId) {
        return getAccessToken(WxCpUtils.buildAppId(corpId, agentId));
    }

    /**
     * 通过code获取用户信息
     *
     * @param appId
     *         appId
     * @param code
     *         code
     * @return 企业微信用户Oauth信息
     */
    WxCpOauth2UserInfoDTO getCodeInfo(String appId, String code);

    /**
     * 通过code获取用户信息
     *
     * @param corpId
     *         corpId
     * @param agentId
     *         agentId
     * @param code
     *         code
     * @return 企业微信用户Oauth信息
     */
    default WxCpOauth2UserInfoDTO getCodeInfo(String corpId, Integer agentId, String code) {
        return getCodeInfo(WxCpUtils.buildAppId(corpId, agentId), code);
    }
}
