/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.wx.api.feign.factory;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.guerlab.smart.wx.api.feign.FeignWxUserApi;
import net.guerlab.smart.wx.core.domain.WxUserDTO;
import net.guerlab.web.result.Fail;
import net.guerlab.web.result.ListObject;
import net.guerlab.web.result.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.openfeign.FallbackFactory;

public class FeignWxUserApiFallbackFactory
implements FallbackFactory<FeignWxUserApi> {
    public FeignWxUserApi create(Throwable cause) {
        return new FeignWxUserApiFallback(cause);
    }

    static class FeignWxUserApiFallback
    implements FeignWxUserApi {
        private static final Logger log = LoggerFactory.getLogger(FeignWxUserApiFallback.class);
        private final Throwable cause;

        @Override
        public Result<WxUserDTO> findOne(String appId, String openId) {
            log.error("findOne fallback", this.cause);
            return new Fail("fallback");
        }

        @Override
        public Result<ListObject<WxUserDTO>> findList(Map<String, Object> searchParams) {
            log.error("findList fallback", this.cause);
            return new Fail("fallback", (Object)ListObject.empty());
        }

        @Override
        public Result<List<WxUserDTO>> findAll(Map<String, Object> searchParams) {
            log.error("findAll fallback", this.cause);
            return new Fail("fallback", Collections.emptyList());
        }

        @Override
        public Result<Map<String, WxUserDTO>> findMap(Collection<String> openIds) {
            log.error("findMap fallback", this.cause);
            return new Fail("fallback", Collections.emptyMap());
        }

        @Override
        public Result<Integer> findCount(Map<String, Object> searchParams) {
            log.error("findCount fallback", this.cause);
            return new Fail("fallback", 0);
        }

        public FeignWxUserApiFallback(Throwable cause) {
            this.cause = cause;
        }
    }
}

