/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.smart.wx.api.feign.factory;

import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import net.guerlab.smart.wx.api.feign.FeignWxUserLoginLogApi;
import net.guerlab.smart.wx.core.domain.WxUserLoginLogDTO;
import net.guerlab.web.result.Fail;
import net.guerlab.web.result.ListObject;
import net.guerlab.web.result.Result;
import org.springframework.cloud.openfeign.FallbackFactory;

import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * 微信用户登录记录服务快速失败类构建工厂
 *
 * @author guer
 */
public class FeignWxUserLoginLogApiFallbackFactory implements FallbackFactory<FeignWxUserLoginLogApi> {

    @Override
    public FeignWxUserLoginLogApi create(Throwable cause) {
        return new FeignWxUserLoginLogApiFallback(cause);
    }

    /**
     * 微信用户登录记录服务快速失败实现
     */
    @Slf4j
    @AllArgsConstructor
    static class FeignWxUserLoginLogApiFallback implements FeignWxUserLoginLogApi {

        private final Throwable cause;

        @Override
        public Result<ListObject<WxUserLoginLogDTO>> findList(Map<String, Object> searchParams) {
            log.error("findList fallback", cause);
            return new Fail<>("fallback", ListObject.empty());
        }

        @Override
        public Result<List<WxUserLoginLogDTO>> findAll(Map<String, Object> searchParams) {
            log.error("findAll fallback", cause);
            return new Fail<>("fallback", Collections.emptyList());
        }
    }
}
