/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.smart.wx.api.feign.factory;

import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import net.guerlab.smart.wx.api.feign.FeignWxMpApi;
import net.guerlab.smart.wx.core.domain.LoginResponse;
import net.guerlab.web.result.Fail;
import net.guerlab.web.result.Result;
import org.springframework.cloud.openfeign.FallbackFactory;

/**
 * 微信公众号服务快速失败类构建工厂
 *
 * @author guer
 */
public class FeignWxMpApiFallbackFactory implements FallbackFactory<FeignWxMpApi> {

    @Override
    public FeignWxMpApi create(Throwable cause) {
        return new FeignWxMpApiFallback(cause);
    }

    /**
     * 微信公众号服务快速失败实现
     */
    @Slf4j
    @AllArgsConstructor
    static class FeignWxMpApiFallback implements FeignWxMpApi {

        private final Throwable cause;

        @Override
        public Result<LoginResponse> login(String appId, String code) {
            log.error("login fallback", cause);
            return new Fail<>("fallback");
        }

        @Override
        public Result<String> getAccessToken(String appId) {
            log.error("getAccessToken fallback", cause);
            return new Fail<>("fallback");
        }
    }
}
