/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.smart.wx.api.feign.factory;

import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import net.guerlab.smart.wx.api.feign.FeignWxMaContentSecurityApi;
import net.guerlab.web.result.Fail;
import net.guerlab.web.result.Result;
import org.springframework.cloud.openfeign.FallbackFactory;

/**
 * 小程序-内容安全服务快速失败类构建工厂
 *
 * @author guer
 */
public class FeignWxMaContentSecurityApiFallbackFactory implements FallbackFactory<FeignWxMaContentSecurityApi> {

    @Override
    public FeignWxMaContentSecurityApi create(Throwable cause) {
        return new FeignWxMaContentSecurityApiFallback(cause);
    }

    /**
     * 小程序-内容安全服务快速失败实现
     */
    @Slf4j
    @AllArgsConstructor
    static class FeignWxMaContentSecurityApiFallback implements FeignWxMaContentSecurityApi {

        private final Throwable cause;

        @Override
        public Result<Void> checkImage(String appId, String fileUrl) {
            log.error("checkImage fallback", cause);
            return new Fail<>("fallback");
        }

        @Override
        public Result<Void> checkMessage(String appId, String msg) {
            log.error("checkMessage fallback", cause);
            return new Fail<>("fallback");
        }
    }
}
