/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.smart.wx.api.autoconfig;

import lombok.AllArgsConstructor;
import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.smart.wx.api.WxMpApi;
import net.guerlab.smart.wx.api.feign.FeignWxMpApi;
import net.guerlab.smart.wx.core.domain.LoginResponse;
import net.guerlab.web.result.Result;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * @author guer
 */
@Configuration
@AutoConfigureAfter(WxMpApiLocalServiceAutoConfigure.class)
public class WxMpApiFeignAutoConfigure {

    @SuppressWarnings("SpringJavaInjectionPointsAutowiringInspection")
    @Bean
    @ConditionalOnMissingBean(WxMpApi.class)
    public WxMpApi wxMpApiFeignWrapper(FeignWxMpApi api) {
        return new WxMpApiFeignWrapper(api);
    }

    @AllArgsConstructor
    private static class WxMpApiFeignWrapper implements WxMpApi {

        private final FeignWxMpApi api;

        @Override
        public LoginResponse login(String appId, String code) {
            Result<LoginResponse> result = api.login(appId, code);

            if (result.isStatus()) {
                return result.getData();
            }

            throw new ApplicationException(result.getMessage(), result.getErrorCode());
        }

        @Override
        public String getAccessToken(String appId) {
            Result<String> result = api.getAccessToken(appId);

            if (result.isStatus()) {
                return result.getData();
            }

            throw new ApplicationException(result.getMessage(), result.getErrorCode());
        }
    }

}
