/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.smart.wx.api.autoconfig;

import lombok.AllArgsConstructor;
import net.guerlab.smart.wx.api.WxMaContentSecurityApi;
import net.guerlab.smart.wx.service.service.WxAppService;
import net.guerlab.smart.wx.service.service.WxMaContentSecurityService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.*;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.lang.NonNull;

/**
 * @author guer
 */
@Configuration
@Conditional(WxMaContentSecurityApiLocalServiceAutoConfigure.WrapperCondition.class)
public class WxMaContentSecurityApiLocalServiceAutoConfigure {

    @SuppressWarnings("SpringJavaInjectionPointsAutowiringInspection")
    @Bean
    @ConditionalOnBean(WxAppService.class)
    public WxMaContentSecurityApi wxMaContentSecurityApiLocalServiceWrapper(WxMaContentSecurityService service) {
        return new WxMaContentSecurityApiLocalServiceWrapper(service);
    }

    @SuppressWarnings("WeakerAccess")
    static class WrapperCondition implements Condition {

        @Override
        public boolean matches(@NonNull ConditionContext context, @NonNull AnnotatedTypeMetadata metadata) {
            try {
                return WrapperCondition.class.getClassLoader().loadClass("net.guerlab.smart.wx.service.service.WxMaContentSecurityService") != null;
            } catch (Exception e) {
                return false;
            }
        }
    }

    @AllArgsConstructor
    private static class WxMaContentSecurityApiLocalServiceWrapper implements WxMaContentSecurityApi {

        private final WxMaContentSecurityService service;

        @Override
        public void checkImage(String appId, String fileUrl) {
            service.checkImage(appId, fileUrl);
        }

        @Override
        public void checkMessage(String appId, String msg) {
            service.checkMessage(appId, msg);
        }
    }

}
