/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.smart.wx.api.autoconfig;

import lombok.AllArgsConstructor;
import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.smart.wx.api.WxMaContentSecurityApi;
import net.guerlab.smart.wx.api.feign.FeignWxMaContentSecurityApi;
import net.guerlab.web.result.Result;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * @author guer
 */
@Configuration
@AutoConfigureAfter(WxMaContentSecurityApiLocalServiceAutoConfigure.class)
public class WxMaContentSecurityApiFeignAutoConfigure {

    @SuppressWarnings("SpringJavaInjectionPointsAutowiringInspection")
    @Bean
    @ConditionalOnMissingBean(WxMaContentSecurityApi.class)
    public WxMaContentSecurityApi wxMaContentSecurityApiFeignWrapper(FeignWxMaContentSecurityApi api) {
        return new WxMaContentSecurityApiFeignWrapper(api);
    }

    @AllArgsConstructor
    private static class WxMaContentSecurityApiFeignWrapper implements WxMaContentSecurityApi {

        private final FeignWxMaContentSecurityApi api;

        @Override
        public void checkImage(String appId, String fileUrl) {
            Result<Void> result = api.checkImage(appId, fileUrl);

            if (!result.isStatus()) {
                throw new ApplicationException(result.getMessage(), result.getErrorCode());
            }
        }

        @Override
        public void checkMessage(String appId, String msg) {
            Result<Void> result = api.checkMessage(appId, msg);

            if (!result.isStatus()) {
                throw new ApplicationException(result.getMessage(), result.getErrorCode());
            }
        }
    }

}
