/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.smart.wx.api;

import net.guerlab.smart.wx.core.domain.WxUserLoginLogDTO;
import net.guerlab.smart.wx.core.searchparams.WxUserLoginLogSearchParams;
import net.guerlab.web.result.ListObject;

import java.util.List;

/**
 * 微信用户登录记录服务接口
 *
 * @author guer
 */
public interface WxUserLoginLogApi {

    /**
     * 根据搜索参数查询微信用户登录记录列表
     *
     * @param searchParams
     *         搜索参数
     * @return 微信用户登录记录列表
     */
    ListObject<WxUserLoginLogDTO> findList(WxUserLoginLogSearchParams searchParams);

    /**
     * 根据搜索参数查询微信用户登录记录列表
     *
     * @param searchParams
     *         搜索参数
     * @return 微信用户登录记录列表
     */
    List<WxUserLoginLogDTO> findAll(WxUserLoginLogSearchParams searchParams);
}
