/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.smart.wx.api;

import net.guerlab.smart.wx.core.domain.WxUserDTO;
import net.guerlab.smart.wx.core.searchparams.WxUserSearchParams;
import net.guerlab.web.result.ListObject;

import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * 微信用户服务接口
 *
 * @author guer
 */
public interface WxUserApi {

    /**
     * 根据appId和openId查询微信用户
     *
     * @param appId
     *         appId
     * @param openId
     *         openId
     * @return 微信用户
     */
    WxUserDTO findOne(String appId, String openId);

    /**
     * 根据搜索参数查询微信用户列表
     *
     * @param searchParams
     *         搜索参数
     * @return 微信用户列表
     */
    ListObject<WxUserDTO> findList(WxUserSearchParams searchParams);

    /**
     * 根据搜索参数查询微信用户列表
     *
     * @param searchParams
     *         搜索参数
     * @return 微信用户列表
     */
    List<WxUserDTO> findAll(WxUserSearchParams searchParams);

    /**
     * 根据openId列表查询用户列表
     *
     * @param openIds
     *         openId列表
     * @return 微信用户列表
     */
    Map<String, WxUserDTO> findMap(Collection<String> openIds);

    /**
     * 查询用户数量
     *
     * @param searchParams
     *         搜索参数
     * @return 用户数量
     */
    int findCount(WxUserSearchParams searchParams);
}
