/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.smart.wx.api;

import net.guerlab.smart.wx.core.domain.LoginResponse;

/**
 * 微信公众号服务接口
 *
 * @author guer
 */
public interface WxMpApi {

    /**
     * 换取token
     *
     * @param appId
     *         appId
     * @param code
     *         code
     * @return 微信用户
     */
    LoginResponse login(String appId, String code);

    /**
     * 获取accessToken
     *
     * @param appId
     *         appId
     * @return accessToken
     */
    String getAccessToken(String appId);
}
