/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.smart.wx.api;

import net.guerlab.smart.wx.core.message.SendMsgResponse;
import net.guerlab.smart.wx.core.message.WxMaSubscribeMessageSendRequest;

import java.util.Map;

/**
 * 微信小程序订阅消息服务接口
 *
 * @author guer
 */
public interface WxMaSubscribeMsgApi {

    /**
     * 发送订阅通知
     *
     * @param appId
     *         应用ID
     * @param request
     *         请求数据
     * @return 发送结果
     */
    Map<String, SendMsgResponse> sendMsg(String appId, WxMaSubscribeMessageSendRequest request);
}
