/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.smart.wx.api;

import net.guerlab.smart.wx.core.domain.WxAppDTO;
import net.guerlab.smart.wx.core.searchparams.WxAppSearchParams;
import net.guerlab.web.result.ListObject;

import java.util.List;

/**
 * 微信应用服务接口
 *
 * @author guer
 */
public interface WxAppApi {

    /**
     * 根据appId查询微信应用
     *
     * @param appId
     *         appId
     * @return 微信应用
     */
    WxAppDTO findOne(String appId);

    /**
     * 根据搜索参数查询微信应用列表
     *
     * @param searchParams
     *         搜索参数
     * @return 微信应用列表
     */
    ListObject<WxAppDTO> findList(WxAppSearchParams searchParams);

    /**
     * 根据搜索参数查询微信应用列表
     *
     * @param searchParams
     *         搜索参数
     * @return 微信应用列表
     */
    List<WxAppDTO> findAll(WxAppSearchParams searchParams);
}
