/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.wx.api.autoconfig;

import me.chanjar.weixin.common.error.WxErrorException;
import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.smart.wx.api.WxMpApi;
import net.guerlab.smart.wx.core.domain.LoginResponse;
import net.guerlab.smart.wx.service.service.WxMpLoginService;
import net.guerlab.smart.wx.service.service.WxMpManagerService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.lang.NonNull;

@Configuration
@Conditional(value={WrapperCondition.class})
public class WxMpApiLocalServiceAutoConfigure {
    @Bean
    @ConditionalOnBean(value={WxMpLoginService.class})
    public WxMpApi wxMpApiLocalServiceWrapper(WxMpLoginService service, WxMpManagerService managerService) {
        return new WxMpApiLocalServiceWrapper(service, managerService);
    }

    private static class WxMpApiLocalServiceWrapper
    implements WxMpApi {
        private final WxMpLoginService service;
        private final WxMpManagerService managerService;

        @Override
        public LoginResponse login(String appId, String code) {
            try {
                return this.service.login(appId, code, "inside", "inside", null);
            }
            catch (Exception e) {
                throw new ApplicationException(e.getLocalizedMessage(), (Throwable)e);
            }
        }

        @Override
        public String getAccessToken(String appId) {
            try {
                return this.managerService.getService(appId).getAccessToken();
            }
            catch (WxErrorException e) {
                throw new ApplicationException(e.getError().getErrorMsg(), (Throwable)e, e.getError().getErrorCode());
            }
        }

        public WxMpApiLocalServiceWrapper(WxMpLoginService service, WxMpManagerService managerService) {
            this.service = service;
            this.managerService = managerService;
        }
    }

    static class WrapperCondition
    implements Condition {
        WrapperCondition() {
        }

        public boolean matches(@NonNull ConditionContext context, @NonNull AnnotatedTypeMetadata metadata) {
            try {
                ClassLoader classLoader = WrapperCondition.class.getClassLoader();
                return classLoader.loadClass("net.guerlab.smart.wx.service.service.WxMpLoginService") != null && classLoader.loadClass("net.guerlab.smart.wx.service.service.WxMpManagerService") != null;
            }
            catch (Exception e) {
                return false;
            }
        }
    }
}

