/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.wx.api.autoconfig;

import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.smart.wx.api.WxMaContentSecurityApi;
import net.guerlab.smart.wx.api.autoconfig.WxMaContentSecurityApiLocalServiceAutoConfigure;
import net.guerlab.smart.wx.api.feign.FeignWxMaContentSecurityApi;
import net.guerlab.web.result.Result;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={WxMaContentSecurityApiLocalServiceAutoConfigure.class})
public class WxMaContentSecurityApiFeignAutoConfigure {
    @Bean
    @ConditionalOnMissingBean(value={WxMaContentSecurityApi.class})
    public WxMaContentSecurityApi wxMaContentSecurityApiFeignWrapper(FeignWxMaContentSecurityApi api) {
        return new WxMaContentSecurityApiFeignWrapper(api);
    }

    private static class WxMaContentSecurityApiFeignWrapper
    implements WxMaContentSecurityApi {
        private final FeignWxMaContentSecurityApi api;

        @Override
        public void checkImage(String appId, String fileUrl) {
            Result<Void> result = this.api.checkImage(appId, fileUrl);
            if (!result.isStatus()) {
                throw new ApplicationException(result.getMessage(), result.getErrorCode());
            }
        }

        @Override
        public void checkMessage(String appId, String msg) {
            Result<Void> result = this.api.checkMessage(appId, msg);
            if (!result.isStatus()) {
                throw new ApplicationException(result.getMessage(), result.getErrorCode());
            }
        }

        public WxMaContentSecurityApiFeignWrapper(FeignWxMaContentSecurityApi api) {
            this.api = api;
        }
    }
}

