package net.guerlab.smart.wx.api.feign.factory;

import feign.hystrix.FallbackFactory;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import net.guerlab.smart.wx.api.feign.FeignWxMaContentSecurityApi;
import net.guerlab.web.result.Fail;
import net.guerlab.web.result.Result;

/**
 * 小程序-内容安全服务快速失败类构建工厂
 *
 * @author guer
 */
public class FeignWxMaContentSecurityApiFallbackFactory implements FallbackFactory<FeignWxMaContentSecurityApi> {

    @Override
    public FeignWxMaContentSecurityApi create(Throwable cause) {
        return new FeignWxMaContentSecurityApiFallback(cause);
    }

    /**
     * 小程序-内容安全服务快速失败实现
     */
    @Slf4j
    @AllArgsConstructor
    static class FeignWxMaContentSecurityApiFallback implements FeignWxMaContentSecurityApi {

        private final Throwable cause;

        @Override
        public Result<Void> checkImage(String appId, String fileUrl) {
            log.error("checkImage fallback", cause);
            return new Fail<>("fallback");
        }

        @Override
        public Result<Void> checkMessage(String appId, String msg) {
            log.error("checkMessage fallback", cause);
            return new Fail<>("fallback");
        }
    }
}
