package net.guerlab.smart.wx.api.feign.factory;

import feign.hystrix.FallbackFactory;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import net.guerlab.smart.wx.api.feign.FeignWxUserLoginLogApi;
import net.guerlab.smart.wx.core.domain.WxUserLoginLogDTO;
import net.guerlab.web.result.Fail;
import net.guerlab.web.result.ListObject;
import net.guerlab.web.result.Result;

import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * 微信用户登录记录服务快速失败类构建工厂
 *
 * @author guer
 */
public class FeignWxUserLoginLogApiFallbackFactory implements FallbackFactory<FeignWxUserLoginLogApi> {

    @Override
    public FeignWxUserLoginLogApi create(Throwable cause) {
        return new FeignWxUserLoginLogApiFallback(cause);
    }

    /**
     * 微信用户登录记录服务快速失败实现
     */
    @Slf4j
    @AllArgsConstructor
    static class FeignWxUserLoginLogApiFallback implements FeignWxUserLoginLogApi {

        private final Throwable cause;

        @Override
        public Result<ListObject<WxUserLoginLogDTO>> findList(Map<String, Object> searchParams) {
            log.error("findList fallback", cause);
            return new Fail<>("fallback", ListObject.empty());
        }

        @Override
        public Result<List<WxUserLoginLogDTO>> findAll(Map<String, Object> searchParams) {
            log.error("findAll fallback", cause);
            return new Fail<>("fallback", Collections.emptyList());
        }
    }
}
