/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.wx.api.autoconfig;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.guerlab.smart.wx.api.WxUserApi;
import net.guerlab.smart.wx.api.autoconfig.WxUserApiLocalServiceAutoConfigure;
import net.guerlab.smart.wx.api.feign.FeignWxUserApi;
import net.guerlab.smart.wx.core.domain.WxUserDTO;
import net.guerlab.smart.wx.core.exception.WxUserInvalidException;
import net.guerlab.smart.wx.core.searchparams.WxUserSearchParams;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import net.guerlab.spring.searchparams.SearchParamsUtils;
import net.guerlab.web.result.ListObject;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={WxUserApiLocalServiceAutoConfigure.class})
public class WxUserApiFeignAutoConfigure {
    @Bean
    @ConditionalOnMissingBean(value={WxUserApi.class})
    public WxUserApi wxUserApiFeignWrapper(FeignWxUserApi api) {
        return new WxUserApiFeignWrapper(api);
    }

    private static class WxUserApiFeignWrapper
    implements WxUserApi {
        private final FeignWxUserApi api;

        @Override
        public WxUserDTO findOne(String appId, String openId) {
            return Optional.ofNullable((WxUserDTO)this.api.findOne(appId, openId).getData()).orElseThrow(WxUserInvalidException::new);
        }

        @Override
        public ListObject<WxUserDTO> findList(WxUserSearchParams searchParams) {
            HashMap<String, Object> params = new HashMap<String, Object>(8);
            SearchParamsUtils.handler((AbstractSearchParams)searchParams, params);
            return Optional.ofNullable((ListObject)this.api.findList(params).getData()).orElse(ListObject.empty());
        }

        @Override
        public List<WxUserDTO> findAll(WxUserSearchParams searchParams) {
            HashMap<String, Object> params = new HashMap<String, Object>(8);
            SearchParamsUtils.handler((AbstractSearchParams)searchParams, params);
            return Optional.ofNullable((List)this.api.findAll(params).getData()).orElse(Collections.emptyList());
        }

        @Override
        public Map<String, WxUserDTO> findMap(Collection<String> openIds) {
            return Optional.ofNullable((Map)this.api.findMap(openIds).getData()).orElse(Collections.emptyMap());
        }

        @Override
        public int findCount(WxUserSearchParams searchParams) {
            HashMap<String, Object> params = new HashMap<String, Object>(8);
            SearchParamsUtils.handler((AbstractSearchParams)searchParams, params);
            return Optional.ofNullable((Integer)this.api.findCount(params).getData()).orElse(0);
        }

        public WxUserApiFeignWrapper(FeignWxUserApi api) {
            this.api = api;
        }
    }
}

