/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.wx.api.autoconfig;

import net.guerlab.smart.wx.api.WxMaContentSecurityApi;
import net.guerlab.smart.wx.service.service.WxAppService;
import net.guerlab.smart.wx.service.service.WxMaContentSecurityService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.lang.NonNull;

@Configuration
@Conditional(value={WrapperCondition.class})
public class WxMaContentSecurityApiLocalServiceAutoConfigure {
    @Bean
    @ConditionalOnBean(value={WxAppService.class})
    public WxMaContentSecurityApi wxMaContentSecurityApiLocalServiceWrapper(WxMaContentSecurityService service) {
        return new WxMaContentSecurityApiLocalServiceWrapper(service);
    }

    private static class WxMaContentSecurityApiLocalServiceWrapper
    implements WxMaContentSecurityApi {
        private final WxMaContentSecurityService service;

        @Override
        public void checkImage(String appId, String fileUrl) {
            this.service.checkImage(appId, fileUrl);
        }

        @Override
        public void checkMessage(String appId, String msg) {
            this.service.checkMessage(appId, msg);
        }

        public WxMaContentSecurityApiLocalServiceWrapper(WxMaContentSecurityService service) {
            this.service = service;
        }
    }

    static class WrapperCondition
    implements Condition {
        WrapperCondition() {
        }

        public boolean matches(@NonNull ConditionContext context, @NonNull AnnotatedTypeMetadata metadata) {
            try {
                return WrapperCondition.class.getClassLoader().loadClass("net.guerlab.smart.wx.service.service.WxMaContentSecurityService") != null;
            }
            catch (Exception e) {
                return false;
            }
        }
    }
}

