/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.wx.api.autoconfig;

import me.chanjar.weixin.common.error.WxErrorException;
import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.smart.wx.api.WxMaApi;
import net.guerlab.smart.wx.api.autoconfig.WxMpApiLocalServiceAutoConfigure;
import net.guerlab.smart.wx.core.domain.LoginResponse;
import net.guerlab.smart.wx.core.domain.MaEncryptedData;
import net.guerlab.smart.wx.service.service.WxMaLoginService;
import net.guerlab.smart.wx.service.service.WxMaManagerService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.lang.NonNull;

@Configuration
@Conditional(value={WrapperCondition.class})
public class WxMaApiLocalServiceAutoConfigure {
    @Bean
    @ConditionalOnBean(value={WxMaLoginService.class})
    public WxMaApi wxMaApiLocalServiceWrapper(WxMaLoginService service, WxMaManagerService managerService) {
        return new WxMaApiLocalServiceWrapper(service, managerService);
    }

    private static class WxMaApiLocalServiceWrapper
    implements WxMaApi {
        private final WxMaLoginService service;
        private final WxMaManagerService managerService;

        @Override
        public LoginResponse login(String appId, String code) {
            try {
                return this.service.login(appId, code, "inside", "inside");
            }
            catch (Exception e) {
                throw new ApplicationException(e.getLocalizedMessage(), (Throwable)e);
            }
        }

        @Override
        public LoginResponse register(String appId, String openId, MaEncryptedData encryptedData) {
            try {
                return this.service.register(appId, openId, encryptedData);
            }
            catch (Exception e) {
                throw new ApplicationException(e.getLocalizedMessage(), (Throwable)e);
            }
        }

        @Override
        public String getAccessToken(String appId) {
            try {
                return this.managerService.getService(appId).getAccessToken();
            }
            catch (WxErrorException e) {
                throw new ApplicationException(e.getError().getErrorMsg(), (Throwable)e, e.getError().getErrorCode());
            }
        }

        public WxMaApiLocalServiceWrapper(WxMaLoginService service, WxMaManagerService managerService) {
            this.service = service;
            this.managerService = managerService;
        }
    }

    static class WrapperCondition
    implements Condition {
        WrapperCondition() {
        }

        public boolean matches(@NonNull ConditionContext context, @NonNull AnnotatedTypeMetadata metadata) {
            try {
                ClassLoader classLoader = WxMpApiLocalServiceAutoConfigure.WrapperCondition.class.getClassLoader();
                return classLoader.loadClass("net.guerlab.smart.wx.service.service.WxMaLoginService") != null && classLoader.loadClass("net.guerlab.smart.wx.service.service.WxMaManagerService") != null;
            }
            catch (Exception e) {
                return false;
            }
        }
    }
}

