/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.wx.api.autoconfig;

import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.smart.wx.api.WxCpApi;
import net.guerlab.smart.wx.api.autoconfig.WxCpApiLocalServiceAutoConfigure;
import net.guerlab.smart.wx.api.feign.FeignWxCpApi;
import net.guerlab.smart.wx.core.domain.WxCpOauth2UserInfoDTO;
import net.guerlab.web.result.Result;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={WxCpApiLocalServiceAutoConfigure.class})
public class WxCpApiFeignAutoConfigure {
    @Bean
    @ConditionalOnMissingBean(value={WxCpApi.class})
    public WxCpApi wxCpApiFeignWrapper(FeignWxCpApi api) {
        return new WxCpApiFeignWrapper(api);
    }

    private static class WxCpApiFeignWrapper
    implements WxCpApi {
        private final FeignWxCpApi api;

        @Override
        public String getAccessToken(String appId) {
            Result<String> result = this.api.getAccessToken(appId);
            if (result.isStatus()) {
                return (String)result.getData();
            }
            throw new ApplicationException(result.getMessage(), result.getErrorCode());
        }

        @Override
        public WxCpOauth2UserInfoDTO getCodeInfo(String appId, String code) {
            Result<WxCpOauth2UserInfoDTO> result = this.api.getCodeInfo(appId, code);
            if (result.isStatus()) {
                return (WxCpOauth2UserInfoDTO)result.getData();
            }
            throw new ApplicationException(result.getMessage(), result.getErrorCode());
        }

        public WxCpApiFeignWrapper(FeignWxCpApi api) {
            this.api = api;
        }
    }
}

