package net.guerlab.smart.wx.api.feign.factory;

import feign.hystrix.FallbackFactory;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import net.guerlab.smart.wx.api.feign.FeignWxMpTemplateMsgApi;
import net.guerlab.smart.wx.core.message.SendMsgResponse;
import net.guerlab.smart.wx.core.message.WxMpTemplateMessageSendRequest;
import net.guerlab.web.result.Fail;
import net.guerlab.web.result.Result;

import java.util.Collections;
import java.util.Map;

/**
 * 微信公众号模版消息服务快速失败类构建工厂
 *
 * @author guer
 */
public class FeignWxMpTemplateMsgApiFallbackFactory implements FallbackFactory<FeignWxMpTemplateMsgApi> {

    @Override
    public FeignWxMpTemplateMsgApi create(Throwable cause) {
        return new FeignWxMpTemplateMsgApiFallback(cause);
    }

    /**
     * 微信公众号模版消息服务快速失败实现
     */
    @Slf4j
    @AllArgsConstructor
    static class FeignWxMpTemplateMsgApiFallback implements FeignWxMpTemplateMsgApi {

        private final Throwable cause;

        @Override
        public Result<Map<String, SendMsgResponse>> sendMsg(String appId, WxMpTemplateMessageSendRequest request) {
            log.error("findAll fallback", cause);
            return new Fail<>("fallback", Collections.emptyMap());
        }
    }
}
