package net.guerlab.smart.wx.api.feign.factory;

import feign.hystrix.FallbackFactory;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import net.guerlab.smart.wx.api.feign.FeignWxCpApi;
import net.guerlab.smart.wx.core.domain.WxCpOauth2UserInfoDTO;
import net.guerlab.web.result.Fail;
import net.guerlab.web.result.Result;

/**
 * 企业微信服务快速失败类构建工厂
 *
 * @author guer
 */
public class FeignWxCpApiFallbackFactory implements FallbackFactory<FeignWxCpApi> {

    @Override
    public FeignWxCpApi create(Throwable cause) {
        return new FeignWxCpApiFallback(cause);
    }

    /**
     * 企业微信服务快速失败实现
     */
    @Slf4j
    @AllArgsConstructor
    static class FeignWxCpApiFallback implements FeignWxCpApi {

        private final Throwable cause;

        @Override
        public Result<String> getAccessToken(String appId) {
            log.error("getAccessToken fallback", cause);
            return new Fail<>("fallback");
        }

        @Override
        public Result<WxCpOauth2UserInfoDTO> getCodeInfo(String appId, String code) {
            log.error("getCodeInfo fallback", cause);
            return new Fail<>("fallback");
        }
    }
}
