package net.guerlab.smart.wx.api.feign.factory;

import feign.hystrix.FallbackFactory;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import net.guerlab.smart.wx.api.feign.FeignWxAppApi;
import net.guerlab.smart.wx.core.domain.WxAppDTO;
import net.guerlab.web.result.Fail;
import net.guerlab.web.result.ListObject;
import net.guerlab.web.result.Result;

import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * 微信应用服务快速失败类构建工厂
 *
 * @author guer
 */
public class FeignWxAppApiFallbackFactory implements FallbackFactory<FeignWxAppApi> {

    @Override
    public FeignWxAppApi create(Throwable cause) {
        return new FeignWxAppApiFallback(cause);
    }

    /**
     * 微信应用服务快速失败实现
     */
    @Slf4j
    @AllArgsConstructor
    static class FeignWxAppApiFallback implements FeignWxAppApi {

        private final Throwable cause;

        @Override
        public Result<WxAppDTO> findOne(String appId) {
            log.error("findOne fallback", cause);
            return new Fail<>("fallback");
        }

        @Override
        public Result<ListObject<WxAppDTO>> findList(Map<String, Object> searchParams) {
            log.error("findList fallback", cause);
            return new Fail<>("fallback", ListObject.empty());
        }

        @Override
        public Result<List<WxAppDTO>> findAll(Map<String, Object> searchParams) {
            log.error("findAll fallback", cause);
            return new Fail<>("fallback", Collections.emptyList());
        }
    }
}
