package net.guerlab.smart.wx.api.feign;

import net.guerlab.smart.wx.api.feign.factory.FeignWxUserLoginLogApiFallbackFactory;
import net.guerlab.smart.wx.core.domain.WxUserLoginLogDTO;
import net.guerlab.web.result.ListObject;
import net.guerlab.web.result.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;
import java.util.Map;

/**
 * 微信用户登录记录服务接口
 *
 * @author guer
 */
@FeignClient(name = "wx-internal/inside/wxUserLoginLog", fallbackFactory = FeignWxUserLoginLogApiFallbackFactory.class)
public interface FeignWxUserLoginLogApi {

    /**
     * 根据搜索参数查询微信用户登录记录列表
     *
     * @param searchParams
     *         搜索参数
     * @return 微信用户登录记录列表
     */
    @PostMapping
    Result<ListObject<WxUserLoginLogDTO>> findList(@RequestBody Map<String, Object> searchParams);

    /**
     * 根据搜索参数查询微信用户登录记录列表
     *
     * @param searchParams
     *         搜索参数
     * @return 微信用户登录记录列表
     */
    @PostMapping("/all")
    Result<List<WxUserLoginLogDTO>> findAll(@RequestBody Map<String, Object> searchParams);
}
