package net.guerlab.smart.wx.api.feign;

import net.guerlab.smart.wx.api.feign.factory.FeignWxUserApiFallbackFactory;
import net.guerlab.smart.wx.core.domain.WxUserDTO;
import net.guerlab.web.result.ListObject;
import net.guerlab.web.result.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * 微信用户服务接口
 *
 * @author guer
 */
@FeignClient(name = "wx-internal/inside/wxUser", fallbackFactory = FeignWxUserApiFallbackFactory.class)
public interface FeignWxUserApi {

    /**
     * 根据appId和openId查询微信用户
     *
     * @param appId
     *         appId
     * @param openId
     *         openId
     * @return 微信用户
     */
    @GetMapping("/{appId}/{openId}")
    Result<WxUserDTO> findOne(@PathVariable("appId") String appId, @PathVariable("openId") String openId);

    /**
     * 根据搜索参数查询微信用户列表
     *
     * @param searchParams
     *         搜索参数
     * @return 微信用户列表
     */
    @PostMapping
    Result<ListObject<WxUserDTO>> findList(@RequestBody Map<String, Object> searchParams);

    /**
     * 根据搜索参数查询微信用户列表
     *
     * @param searchParams
     *         搜索参数
     * @return 微信用户列表
     */
    @PostMapping("/all")
    Result<List<WxUserDTO>> findAll(@RequestBody Map<String, Object> searchParams);

    /**
     * 根据openId列表查询用户列表
     *
     * @param openIds
     *         openId列表
     * @return 微信用户列表
     */
    @PostMapping("/findMap")
    Result<Map<String, WxUserDTO>> findMap(@RequestBody Collection<String> openIds);

    /**
     * 查询用户数量
     *
     * @param searchParams
     *         搜索参数
     * @return 用户数量
     */
    @PostMapping("/count")
    Result<Integer> findCount(@RequestBody Map<String, Object> searchParams);
}
