package net.guerlab.smart.wx.api.feign;

import net.guerlab.smart.wx.api.feign.factory.FeignWxMpApiFallbackFactory;
import net.guerlab.smart.wx.core.domain.LoginResponse;
import net.guerlab.web.result.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;

/**
 * 微信公众号服务接口
 *
 * @author guer
 */
@FeignClient(name = "wx-internal/inside/wx/mp", fallbackFactory = FeignWxMpApiFallbackFactory.class)
public interface FeignWxMpApi {

    /**
     * 换取token
     *
     * @param appId
     *         appId
     * @param code
     *         code
     * @return 微信用户
     */
    @GetMapping("/{appId}/login/{code}")
    Result<LoginResponse> login(@PathVariable("appId") String appId, @PathVariable("code") String code);

    /**
     * 获取accessToken
     *
     * @param appId
     *         appId
     * @return accessToken
     */
    @GetMapping("/{appId}/accessToken")
    Result<String> getAccessToken(@PathVariable("appId") String appId);
}
