package net.guerlab.smart.wx.api.feign;

import net.guerlab.smart.wx.api.feign.factory.FeignWxMaSubscribeMsgApiFallbackFactory;
import net.guerlab.smart.wx.core.message.SendMsgResponse;
import net.guerlab.smart.wx.core.message.WxMaSubscribeMessageSendRequest;
import net.guerlab.web.result.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.Map;

/**
 * 微信小程序订阅消息服务接口
 *
 * @author guer
 */
@FeignClient(name = "wx-internal/inside/wxMaSubscribeMsg", fallbackFactory = FeignWxMaSubscribeMsgApiFallbackFactory.class)
public interface FeignWxMaSubscribeMsgApi {

    /**
     * 发送订阅通知
     *
     * @param appId
     *         应用ID
     * @param request
     *         请求数据
     * @return 发送结果
     */
    @PostMapping("/{appId}/sendMsg")
    Result<Map<String, SendMsgResponse>> sendMsg(@PathVariable("appId") String appId,
            @RequestBody WxMaSubscribeMessageSendRequest request);
}
