package net.guerlab.smart.wx.api.autoconfig;

import lombok.AllArgsConstructor;
import net.guerlab.smart.wx.api.WxMpTemplateMsgApi;
import net.guerlab.smart.wx.core.message.SendMsgResponse;
import net.guerlab.smart.wx.core.message.WxMpTemplateMessageSendRequest;
import net.guerlab.smart.wx.service.controller.mp.AbstractWxMpTemplateMsgController;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.*;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.lang.NonNull;

import java.util.Map;

/**
 * @author guer
 */
@Configuration
@Conditional(WxMpTemplateMsgApiLocalServiceAutoConfigure.WrapperCondition.class)
public class WxMpTemplateMsgApiLocalServiceAutoConfigure {

    @SuppressWarnings("SpringJavaInjectionPointsAutowiringInspection")
    @Bean
    @ConditionalOnBean(AbstractWxMpTemplateMsgController.class)
    public WxMpTemplateMsgApi wxMpTemplateMsgApiLocalServiceWrapper(AbstractWxMpTemplateMsgController controller) {
        return new WxMpTemplateMsgApiLocalServiceWrapper(controller);
    }

    @SuppressWarnings("WeakerAccess")
    static class WrapperCondition implements Condition {

        @Override
        public boolean matches(@NonNull ConditionContext context, @NonNull AnnotatedTypeMetadata metadata) {
            try {
                return WrapperCondition.class.getClassLoader()
                        .loadClass("net.guerlab.smart.wx.service.controller.mp.AbstractWxMpTemplateMsgController")
                        != null;
            } catch (Exception e) {
                return false;
            }
        }
    }

    @AllArgsConstructor
    private static class WxMpTemplateMsgApiLocalServiceWrapper implements WxMpTemplateMsgApi {

        private final AbstractWxMpTemplateMsgController controller;

        @Override
        public Map<String, SendMsgResponse> sendMsg(String appId, WxMpTemplateMessageSendRequest request) {
            return controller.sendMsg(appId, request);
        }
    }

}
