package net.guerlab.smart.wx.api.autoconfig;

import lombok.AllArgsConstructor;
import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.smart.wx.api.WxMpApi;
import net.guerlab.smart.wx.api.feign.FeignWxMpApi;
import net.guerlab.smart.wx.core.domain.LoginResponse;
import net.guerlab.web.result.Result;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * @author guer
 */
@Configuration
@AutoConfigureAfter(WxMpApiLocalServiceAutoConfigure.class)
public class WxMpApiFeignAutoConfigure {

    @SuppressWarnings("SpringJavaInjectionPointsAutowiringInspection")
    @Bean
    @ConditionalOnMissingBean(WxMpApi.class)
    public WxMpApi wxMpApiFeignWrapper(FeignWxMpApi api) {
        return new WxMpApiFeignWrapper(api);
    }

    @AllArgsConstructor
    private static class WxMpApiFeignWrapper implements WxMpApi {

        private final FeignWxMpApi api;

        @Override
        public LoginResponse login(String appId, String code) {
            Result<LoginResponse> result = api.login(appId, code);

            if (result.isStatus()) {
                return result.getData();
            }

            throw new ApplicationException(result.getMessage(), result.getErrorCode());
        }

        @Override
        public String getAccessToken(String appId) {
            Result<String> result = api.getAccessToken(appId);

            if (result.isStatus()) {
                return result.getData();
            }

            throw new ApplicationException(result.getMessage(), result.getErrorCode());
        }
    }

}
