package net.guerlab.smart.wx.api;

import net.guerlab.smart.wx.core.domain.WxUserLoginLogDTO;
import net.guerlab.smart.wx.core.searchparams.WxUserLoginLogSearchParams;
import net.guerlab.web.result.ListObject;

import java.util.List;

/**
 * 微信用户登录记录服务接口
 *
 * @author guer
 */
public interface WxUserLoginLogApi {

    /**
     * 根据搜索参数查询微信用户登录记录列表
     *
     * @param searchParams
     *         搜索参数
     * @return 微信用户登录记录列表
     */
    ListObject<WxUserLoginLogDTO> findList(WxUserLoginLogSearchParams searchParams);

    /**
     * 根据搜索参数查询微信用户登录记录列表
     *
     * @param searchParams
     *         搜索参数
     * @return 微信用户登录记录列表
     */
    List<WxUserLoginLogDTO> findAll(WxUserLoginLogSearchParams searchParams);
}
