package net.guerlab.smart.wx.api;

import net.guerlab.smart.wx.core.domain.WxAppDTO;
import net.guerlab.smart.wx.core.searchparams.WxAppSearchParams;
import net.guerlab.web.result.ListObject;

import java.util.List;

/**
 * 微信应用服务接口
 *
 * @author guer
 */
public interface WxAppApi {

    /**
     * 根据appId查询微信应用
     *
     * @param appId
     *         appId
     * @return 微信应用
     */
    WxAppDTO findOne(String appId);

    /**
     * 根据搜索参数查询微信应用列表
     *
     * @param searchParams
     *         搜索参数
     * @return 微信应用列表
     */
    ListObject<WxAppDTO> findList(WxAppSearchParams searchParams);

    /**
     * 根据搜索参数查询微信应用列表
     *
     * @param searchParams
     *         搜索参数
     * @return 微信应用列表
     */
    List<WxAppDTO> findAll(WxAppSearchParams searchParams);
}
