/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.wx.api.autoconfig;

import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.cp.bean.WxCpOauth2UserInfo;
import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.smart.wx.api.WxCpApi;
import net.guerlab.smart.wx.api.autoconfig.WxMpApiLocalServiceAutoConfigure;
import net.guerlab.smart.wx.core.domain.WxCpOauth2UserInfoDTO;
import net.guerlab.smart.wx.service.service.WxCpManagerService;
import net.guerlab.smart.wx.service.service.WxMaLoginService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.lang.NonNull;

@Configuration
@Conditional(value={WrapperCondition.class})
public class WxCpApiLocalServiceAutoConfigure {
    @Bean
    @ConditionalOnBean(value={WxMaLoginService.class})
    public WxCpApi wxCpApiLocalServiceWrapper(WxCpManagerService managerService) {
        return new WxCpApiLocalServiceWrapper(managerService);
    }

    private static class WxCpApiLocalServiceWrapper
    implements WxCpApi {
        private final WxCpManagerService managerService;

        @Override
        public String getAccessToken(String appId) {
            try {
                return this.managerService.getService(appId).getAccessToken();
            }
            catch (WxErrorException e) {
                throw new ApplicationException(e.getError().getErrorMsg(), e.getError().getErrorCode());
            }
        }

        @Override
        public WxCpOauth2UserInfoDTO getCodeInfo(String appId, String code) {
            try {
                WxCpOauth2UserInfo userInfo = this.managerService.getService(appId).getOauth2Service().getUserInfo(code);
                WxCpOauth2UserInfoDTO dto = new WxCpOauth2UserInfoDTO();
                dto.setOpenId(userInfo.getOpenId());
                dto.setDeviceId(userInfo.getDeviceId());
                dto.setUserId(userInfo.getUserId());
                dto.setUserTicket(userInfo.getUserTicket());
                dto.setExpiresIn(userInfo.getExpiresIn());
                return dto;
            }
            catch (WxErrorException e) {
                throw new ApplicationException(e.getError().getErrorMsg(), e.getError().getErrorCode());
            }
        }

        public WxCpApiLocalServiceWrapper(WxCpManagerService managerService) {
            this.managerService = managerService;
        }
    }

    static class WrapperCondition
    implements Condition {
        WrapperCondition() {
        }

        public boolean matches(@NonNull ConditionContext context, @NonNull AnnotatedTypeMetadata metadata) {
            try {
                ClassLoader classLoader = WxMpApiLocalServiceAutoConfigure.WrapperCondition.class.getClassLoader();
                return classLoader.loadClass("net.guerlab.smart.wx.service.service.WxCpManagerService") != null;
            }
            catch (Exception e) {
                return false;
            }
        }
    }
}

