package net.guerlab.smart.wx.api.feign.factory;

import feign.hystrix.FallbackFactory;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import net.guerlab.smart.wx.api.feign.FeignWxUserApi;
import net.guerlab.smart.wx.core.domain.WxUserDTO;
import net.guerlab.web.result.Fail;
import net.guerlab.web.result.ListObject;
import net.guerlab.web.result.Result;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * 微信用户服务快速失败类构建工厂
 *
 * @author guer
 */
public class FeignWxUserApiFallbackFactory implements FallbackFactory<FeignWxUserApi> {

    @Override
    public FeignWxUserApi create(Throwable cause) {
        return new FeignWxUserApiFallback(cause);
    }

    /**
     * 微信用户服务快速失败实现
     */
    @Slf4j
    @AllArgsConstructor
    static class FeignWxUserApiFallback implements FeignWxUserApi {

        private final Throwable cause;

        @Override
        public Result<WxUserDTO> findOne(String appId, String openId) {
            log.error("findOne fallback", cause);
            return new Fail<>("fallback");
        }

        @Override
        public Result<ListObject<WxUserDTO>> findList(Map<String, Object> searchParams) {
            log.error("findList fallback", cause);
            return new Fail<>("fallback", ListObject.empty());
        }

        @Override
        public Result<List<WxUserDTO>> findAll(Map<String, Object> searchParams) {
            log.error("findAll fallback", cause);
            return new Fail<>("fallback", Collections.emptyList());
        }

        @Override
        public Result<Map<String, WxUserDTO>> findMap(Collection<String> openIds) {
            log.error("findMap fallback", cause);
            return new Fail<>("fallback", Collections.emptyMap());
        }

        @Override
        public Result<Integer> findCount(Map<String, Object> searchParams) {
            log.error("findCount fallback", cause);
            return new Fail<>("fallback", 0);
        }
    }
}
