package net.guerlab.smart.wx.api.feign;

import net.guerlab.smart.wx.api.feign.factory.FeignWxCpApiFallbackFactory;
import net.guerlab.smart.wx.core.domain.WxCpOauth2UserInfoDTO;
import net.guerlab.web.result.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;

/**
 * 企业微信服务接口
 *
 * @author guer
 */
@FeignClient(name = "wx-internal/inside/wx/cp", fallbackFactory = FeignWxCpApiFallbackFactory.class)
public interface FeignWxCpApi {

    /**
     * 获取accessToken
     *
     * @param appId
     *         appId
     * @return accessToken
     */
    @GetMapping("/{appId}/accessToken")
    Result<String> getAccessToken(@PathVariable("appId") String appId);

    /**
     * 通过code获取用户信息
     *
     * @param appId
     *         appId
     * @param code
     *         code
     * @return 企业微信用户Oauth信息
     */
    @GetMapping("/{appId}/{code}/getCodeInfo")
    Result<WxCpOauth2UserInfoDTO> getCodeInfo(@PathVariable("appId") String appId, @PathVariable("code") String code);
}
