package net.guerlab.smart.wx.api.feign.factory;

import feign.hystrix.FallbackFactory;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import net.guerlab.smart.wx.api.feign.FeignWxMaSubscribeMsgApi;
import net.guerlab.smart.wx.core.message.SendMsgResponse;
import net.guerlab.smart.wx.core.message.WxMaSubscribeMessageSendRequest;
import net.guerlab.web.result.Fail;
import net.guerlab.web.result.Result;

import java.util.Collections;
import java.util.Map;

/**
 * 微信小程序订阅消息服务快速失败类构建工厂
 *
 * @author guer
 */
public class FeignWxMaSubscribeMsgApiFallbackFactory implements FallbackFactory<FeignWxMaSubscribeMsgApi> {

    @Override
    public FeignWxMaSubscribeMsgApi create(Throwable cause) {
        return new FeignWxMaSubscribeMsgApiFallback(cause);
    }

    /**
     * 微信小程序订阅消息服务快速失败实现
     */
    @Slf4j
    @AllArgsConstructor
    static class FeignWxMaSubscribeMsgApiFallback implements FeignWxMaSubscribeMsgApi {

        private final Throwable cause;

        @Override
        public Result<Map<String, SendMsgResponse>> sendMsg(String appId, WxMaSubscribeMessageSendRequest request) {
            log.error("findAll fallback", cause);
            return new Fail<>("fallback", Collections.emptyMap());
        }
    }
}
